#!/bin/bash

# A hacky little "screensaver daemon" by Eri! :D
# Last modified: November 20th, 2025, 18:05 CST
# See "ASCIIQuarium How-to By Eri.txt" to set up the ASCIIQuarium Perl script first
# This script requires the packages "xprintidle" and "unclutter-xfixes", and assumes you have XFCE4's terminal installed

clear

echo
echo "Welcome to ASCIIQuarium!"
echo

while true; do # This "while true; do" loop restarts the entire script from this line when it reaches the end

	echo "Starting script..."
	echo

	minutes_until_screensaver_activates=30 # -----===== Reader of this script: change just this value to adjust when the screensaver starts =====-----

	activate_screensaver=$(($minutes_until_screensaver_activates*60*1000)) # This is: minutes, converted to seconds, converted to milliseconds - which is what xprintidle uses

	current_idle_time=0 # Setting to 0 seconds... this will be updated every second by xprintidle from here on out

	while [ $current_idle_time -lt $activate_screensaver ]; do # While the current idle time is less than the threshold that activates the screensaver...
		current_idle_time=$(xprintidle) # Updates current idle time variable based on xprintidle output
		echo "Time until screensaver starts: $current_idle_time/$activate_screensaver (ms)"
		sleep 1
	done

	echo

	unclutter & xfce4-terminal --fullscreen --hide-menubar --hide-borders --command 'perl asciiquarium' #Start Unclutter and ASCIIQuarium processes (the latter in a new, fullscreen terminal window)

	echo "Started Unclutter to hide mouse cursor until the mouse is moved."
	echo "Started screensaver."
	echo

	while [ $current_idle_time -gt 1000 ]; do # The current idle time will obviously be greater than 1 second here at this point in the script... when you move your mouse or press a keyboard key, the first value xprintidle reports will never be 0 seconds, but will always be less than 1 second, hence 1000 milliseconds here
		current_idle_time=$(xprintidle) # Updates current idle time variable based on xprintidle output
		echo "Current idle time: $current_idle_time (ms)"
		sleep 1
	done

	# Pretty sure how I'm doing this next part is *not* best practice, given other processes you may not want killed could *in theory* have these process names; but I couldn't figure out a way to get the process IDs from the child processes this script spawns :'(

	mouse_hider_pid=$(pidof unclutter) # Gets the process ID of the process called "unclutter"
	screensaver_pid=$(pidof perl asciiquarium) # Gets the process ID of the process called "perl asciiquarium"

	echo
	echo "Mouse hider process ID: $mouse_hider_pid"
	echo "Screensaver process ID: $screensaver_pid"
	echo

	kill $mouse_hider_pid # Kills the process based on the ID associated with the one called "unclutter" 
	kill $screensaver_pid # Kills the process based on the ID associated with the one called "perl asciiquarium"	

	echo "Mouse moved or keyboard key pressed, mouse hider and screensaver processes killed."
	echo
	echo "End of script reached. Restarting..."
	echo

done # Returns to line 14